<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'title' => '',
    'createRoute' => null,
    'createText' => 'Add New',
    'columns' => [],
    'ajaxUrl' => '',
    'showSearch' => true,
    'showDateFilter' => false,
    'showExport' => true,
    'tableId' => 'admin-table',
    'extraFilters' => null,
    'customInfoBoxes' => null,
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'title' => '',
    'createRoute' => null,
    'createText' => 'Add New',
    'columns' => [],
    'ajaxUrl' => '',
    'showSearch' => true,
    'showDateFilter' => false,
    'showExport' => true,
    'tableId' => 'admin-table',
    'extraFilters' => null,
    'customInfoBoxes' => null,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title"><?php echo e($title); ?></h3>
        <div class="card-tools">
            <?php if($createRoute): ?>
                <a href="<?php echo e($createRoute); ?>" class="btn btn-primary btn-sm">
                    <i class="fas fa-plus"></i> <?php echo e($createText); ?>

                </a>
            <?php endif; ?>
        </div>
    </div>
    
    <?php if($showSearch || $showDateFilter || $extraFilters): ?>
    <div class="card-body border-bottom">
        <form id="filter-form" class="row g-3">
            <?php if($showSearch): ?>
                <div class="col-md-4">
                    <label for="search" class="form-label">Search</label>
                    <input type="text" class="form-control" id="search" name="search" placeholder="Search...">
                </div>
            <?php endif; ?>
            
            <?php if($showDateFilter): ?>
                <div class="col-md-3">
                    <label for="date_from" class="form-label">Date From</label>
                    <input type="date" class="form-control" id="date_from" name="date_from">
                </div>
                <div class="col-md-3">
                    <label for="date_to" class="form-label">Date To</label>
                    <input type="date" class="form-control" id="date_to" name="date_to">
                </div>
            <?php endif; ?>
            
            <?php if($extraFilters): ?>
                <?php echo e($extraFilters); ?>

            <?php endif; ?>
            
            <div class="col-md-2 d-flex align-items-end">
                <button type="button" id="filter-btn" class="btn btn-info me-2">
                    <i class="fas fa-search"></i> Filter
                </button>
                <button type="button" id="clear-btn" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Clear
                </button>
            </div>
        </form>
    </div>
    <?php endif; ?>
    
    <div class="card-body">
        <!-- Info boxes -->
        <?php if($customInfoBoxes): ?>
            <?php echo e($customInfoBoxes); ?>

        <?php else: ?>
            <div class="row mb-3">
                <div class="col-md-3">
                    <div class="info-box">
                        <span class="info-box-icon bg-info"><i class="fas fa-list"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Total Records</span>
                            <span class="info-box-number" id="total-records">0</span>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="info-box">
                        <span class="info-box-icon bg-success"><i class="fas fa-eye"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Showing</span>
                            <span class="info-box-number" id="showing-records">0</span>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="info-box">
                        <span class="info-box-icon bg-warning"><i class="fas fa-filter"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Filtered</span>
                            <span class="info-box-number" id="filtered-records">0</span>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="info-box">
                        <span class="info-box-icon bg-danger"><i class="fas fa-calendar"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Date Range</span>
                            <span class="info-box-number" id="date-range">All Time</span>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Data Table -->
        <table id="<?php echo e($tableId); ?>" class="table table-bordered table-striped table-hover">
            <thead class="table-dark">
                <tr>
                    <?php $__currentLoopData = $columns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th data-field="<?php echo e($column['field'] ?? ''); ?>" 
                            <?php if(isset($column['sortable']) && !$column['sortable']): ?> class="no-sort" <?php endif; ?>>
                            <?php echo e($column['title']); ?>

                        </th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            </thead>
            <tbody>
                <!-- Data will be loaded via AJAX -->
            </tbody>
        </table>
    </div>
</div>

<?php $__env->startPush('style'); ?>
<style>
.info-box {
    box-shadow: 0 0 1px rgba(0,0,0,.125), 0 1px 3px rgba(0,0,0,.2);
    border-radius: .25rem;
    background-color: #fff;
    display: flex;
    margin-bottom: 1rem;
    min-height: 80px;
    padding: .5rem;
    position: relative;
    width: 100%;
}

.info-box .info-box-icon {
    border-radius: .25rem;
    align-items: center;
    display: flex;
    font-size: 1.875rem;
    justify-content: center;
    text-align: center;
    width: 70px;
    color: rgba(255,255,255,.8);
    background: rgba(0,0,0,.1);
}

.info-box .info-box-content {
    display: flex;
    flex-direction: column;
    justify-content: center;
    line-height: 1.8;
    margin-left: 10px;
    padding: 0 10px;
}

.info-box .info-box-text {
    display: block;
    font-size: .875rem;
    font-weight: 600;
    text-transform: uppercase;
    white-space: nowrap;
}

.info-box .info-box-number {
    display: block;
    font-size: 1.125rem;
    font-weight: 700;
}

.table-hover tbody tr:hover {
    background-color: rgba(0,0,0,.075);
}

.dataTables_wrapper .dataTables_info {
    padding-top: 8px;
    white-space: nowrap;
}

.dataTables_wrapper .dataTables_paginate {
    float: right;
    text-align: right;
    padding-top: 0;
}

.dataTables_wrapper .dataTables_paginate .paginate_button {
    box-sizing: border-box;
    display: inline-block;
    min-width: 1.5em;
    padding: 0.5em 1em;
    margin-left: 2px;
    text-align: center;
    text-decoration: none !important;
    cursor: pointer;
    border: 1px solid transparent;
    border-radius: 2px;
    color: #333 !important;
}

.dataTables_wrapper .dataTables_paginate .paginate_button:hover {
    color: white !important;
    border: 1px solid #111;
    background-color: #585858;
    background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, #585858), color-stop(100%, #111));
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current {
    color: white !important;
    border: 1px solid #979797;
    background-color: #b0b0b0;
    background: -webkit-gradient(linear, left top, left bottom, color-stop(0%, #b0b0b0), color-stop(100%, #8b8b8b));
}

.table-dark th {
    background-color: #343a40 !important;
    border-color: #454d55 !important;
    color: #fff !important;
}

.btn-group-sm > .btn, .btn-sm {
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
    border-radius: 0.2rem;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
$(document).ready(function() {
    // Initialize DataTable
    var table = $('#<?php echo e($tableId); ?>').DataTable({
        processing: true,
        serverSide: false,
        ajax: {
            url: '<?php echo e($ajaxUrl); ?>',
            data: function(d) {
                // Add custom filters
                <?php if($showSearch): ?>
                d.search = $('#search').val();
                <?php endif; ?>
                <?php if($showDateFilter): ?>
                d.date_from = $('#date_from').val();
                d.date_to = $('#date_to').val();
                <?php endif; ?>
                // Add any extra filter data
                $('#filter-form input, #filter-form select').each(function() {
                    if ($(this).val() && $(this).attr('name')) {
                        d[$(this).attr('name')] = $(this).val();
                    }
                });
            },
            dataSrc: function(json) {
                updateInfoBoxes(json);
                return json.data || [];
            }
        },
        columns: [
            <?php $__currentLoopData = $columns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            {
                data: '<?php echo e($column['field']); ?>',
                <?php if(isset($column['orderable']) && !$column['orderable']): ?>
                orderable: false,
                <?php endif; ?>
                <?php if(isset($column['searchable']) && !$column['searchable']): ?>
                searchable: false,
                <?php endif; ?>
                <?php if(isset($column['render'])): ?>
                render: <?php echo $column['render']; ?>

                <?php endif; ?>
            },
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ],
        responsive: true,
        lengthChange: true,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        autoWidth: false,
        pageLength: 25,
        <?php if($showExport): ?>
        dom: 'Blfrtip',
        buttons: [
            {
                extend: 'copy',
                className: 'btn btn-sm btn-info'
            },
            {
                extend: 'csv',
                className: 'btn btn-sm btn-success'
            },
            {
                extend: 'excel',
                className: 'btn btn-sm btn-success'
            },
            {
                extend: 'pdf',
                className: 'btn btn-sm btn-danger'
            },
            {
                extend: 'print',
                className: 'btn btn-sm btn-warning'
            },
            {
                extend: 'colvis',
                className: 'btn btn-sm btn-secondary',
                text: 'Columns'
            }
        ],
        <?php else: ?>
        dom: 'lfrtip',
        <?php endif; ?>
        language: {
            processing: '<i class="fas fa-spinner fa-spin fa-2x"></i><br>Loading...',
            lengthMenu: 'Show _MENU_ entries',
            info: 'Showing _START_ to _END_ of _TOTAL_ entries',
            infoEmpty: 'No entries available',
            infoFiltered: '(filtered from _MAX_ total entries)',
            search: 'Search:',
            paginate: {
                first: 'First',
                last: 'Last',
                next: 'Next',
                previous: 'Previous'
            }
        },
        order: [[0, 'desc']], // Default sort by first column descending
        drawCallback: function(settings) {
            // Update info after each draw
            updateInfoBoxes(settings.json);
        }
    });

    <?php if($showExport): ?>
    // Style the buttons
    table.buttons().container().appendTo('#<?php echo e($tableId); ?>_wrapper .col-md-6:eq(0)');
    <?php endif; ?>

    // Filter button click
    $('#filter-btn').on('click', function() {
        table.ajax.reload();
    });

    // Clear button click
    $('#clear-btn').on('click', function() {
        $('#filter-form')[0].reset();
        table.ajax.reload();
        $('#date-range').text('All Time');
    });

    // Auto-filter on input change (with debounce for text inputs, instant for selects)
    var timeout;
    
    // Instant filtering for select dropdowns
    $('#filter-form select').on('change', function() {
        var $this = $(this);
        // Show loading feedback
        $this.addClass('bg-light').prop('disabled', true);
        
        console.log('Filter changed:', $this.attr('name'), '=', $this.val());
        
        table.ajax.reload(function() {
            // Remove loading feedback after reload
            $this.removeClass('bg-light').prop('disabled', false);
        });
    });
    
    // Debounced filtering for text inputs and date inputs
    $('#filter-form input').on('input change', function() {
        clearTimeout(timeout);
        var $input = $(this);
        timeout = setTimeout(function() {
            $input.addClass('bg-light');
            table.ajax.reload(function() {
                $('#filter-form input').removeClass('bg-light');
            });
        }, 300); // Reduced from 500ms to 300ms for faster response
    });

    // Update date range display
    $('#date_from, #date_to').on('change', function() {
        var dateFrom = $('#date_from').val();
        var dateTo = $('#date_to').val();
        
        if (dateFrom && dateTo) {
            $('#date-range').text(dateFrom + ' to ' + dateTo);
        } else if (dateFrom) {
            $('#date-range').text('From ' + dateFrom);
        } else if (dateTo) {
            $('#date-range').text('Until ' + dateTo);
        } else {
            $('#date-range').text('All Time');
        }
    });

    // Function to update info boxes
    function updateInfoBoxes(json) {
        if (json) {
            $('#total-records').text(json.recordsTotal || 0);
            $('#showing-records').text(json.recordsFiltered || 0);
            $('#filtered-records').text((json.recordsTotal || 0) - (json.recordsFiltered || 0));
            
            // Debug: Log the json response
            console.log('AJAX Response:', json);
            
            // Update stock counts
            if (json.stockPhones !== undefined) {
                console.log('Updating stock phones:', json.stockPhones);
                $('#stock-phones').text(json.stockPhones || 0);
            }
            if (json.stockAccessories !== undefined) {
                console.log('Updating stock accessories:', json.stockAccessories);
                $('#stock-accessories').text(json.stockAccessories || 0);
            }
        }
    }
});
</script>
<?php $__env->stopPush(); ?><?php /**PATH C:\xampp\htdocs\pos v24.4\resources\views/components/admin-table.blade.php ENDPATH**/ ?>